/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CanOpenMaster_Public.h $
   Last Modification:
    $Author: phuong $
    $Modtime: 6.10.08 13:33 $
    $Revision: 15 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CanOpen Master
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     16         03.12.12   ES
         Added CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ/CNF
     15         30.01.12   ES
         Addded CANOPEN_MASTER_SLAVE_ACTIVATE_REQ/CNF

     14         12.03.10   ES
        Corrected maximum value for COB-ID SYNC from 0x7FFF to 0x7FF
     
     13         08.02.10   ES
        Added definition for SDO index and sub-index
     
     12         28.01.10   ES
        Changed definitions for format

     11         02.10.08   ES
        Increased datacount for SDO-Requests to 512 bytes
        Added send and receive data count to state change indication packet
        Added packet definition for get slave connection state
     
     8          04.09.07    Eric
        Changed upper limit for SYNC- and Heartbeat-Time to 0x0000ffffL
       
     6          02.07.07    Eric
        Added diagnostic information for bootup-messages
     
     5          20.06.07    Eric
        Corrected definition for state not handled flag
        Corrected definitions for send and receive index in data exchange request              

     4          13.06.07    Eric
        Added 'CANOPEN_MASTER_APP_REGISTER_CNF_DATA_T'

     3          13.06.07    Eric
        Corrected data type of parameter ulReserved in structure
        'CANOPEN_MASTER_APP_REGISTER_REQ_DATA_T'

     2          18.04.07    Eric
        Removed definition for deactivated SYNC parameter

     1          13.04.07    Eric
        Created     
**************************************************************************************/
/**
 * @file CanOpenMaster_Public.h
 *  CanOpen Master - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 */
#ifndef __CANOPEN_MASTER_PUBLIC_H
#define __CANOPEN_MASTER_PUBLIC_H

#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__CANOPEN_MASTER_PUBLIC)
#endif

#define CANOPEN_MASTER_REGISTER_REQ                     0x00002800
#define CANOPEN_MASTER_REGISTER_CNF                     0x00002801

#define CANOPEN_MASTER_STARTSTOP_REQ                    0x00002802
#define CANOPEN_MASTER_STARTSTOP_CNF                    0x00002803

#define CANOPEN_MASTER_INITIALIZE_REQ                   0x00002804
#define CANOPEN_MASTER_INITIALIZE_CNF                   0x00002805

#define CANOPEN_MASTER_SET_BUS_PARAM_REQ                0x00002806
#define CANOPEN_MASTER_SET_BUS_PARAM_CNF                0x00002807

#define CANOPEN_MASTER_SET_NODE_PARAM_REQ               0x00002808
#define CANOPEN_MASTER_SET_NODE_PARAM_CNF               0x00002809

#define CANOPEN_MASTER_EXCHANGE_DATA_REQ                0x0000280A
#define CANOPEN_MASTER_EXCHANGE_DATA_CNF                0x0000280B

#define CANOPEN_MASTER_GET_BUFFER_HANDLE_REQ            0x0000280C
#define CANOPEN_MASTER_GET_BUFFER_HANDLE_CNF            0x0000280D

#define CANOPEN_MASTER_GET_NODE_DIAG_REQ                0x0000280E
#define CANOPEN_MASTER_GET_NODE_DIAG_CNF                0x0000280F

#define CANOPEN_MASTER_STATE_CHANGE_IND                 0x00002812
#define CANOPEN_MASTER_STATE_CHANGE_RES                 0x00002813

#define CANOPEN_MASTER_SDO_UPLOAD_REQ                   0x00002814
#define CANOPEN_MASTER_SDO_UPLOAD_CNF                   0x00002815

#define CANOPEN_MASTER_SDO_DOWNLOAD_REQ                 0x00002816
#define CANOPEN_MASTER_SDO_DOWNLOAD_CNF                 0x00002817

#define CANOPEN_MASTER_SEND_EMCY_REQ                    0x00002818
#define CANOPEN_MASTER_SEND_EMCY_CNF                    0x00002819

#define CANOPEN_MASTER_NODE_NMT_COMMAND_REQ             0x0000281A
#define CANOPEN_MASTER_NODE_NMT_COMMAND_CNF             0x0000281B

#define CANOPEN_MASTER_SET_WATCHDOG_FAIL_REQ            0x000028AA
#define CANOPEN_MASTER_SET_WATCHDOG_FAIL_CNF            0x000028AB

#define CANOPEN_MASTER_SLAVE_ACTIVATE_REQ               0x000028AC
#define CANOPEN_MASTER_SLAVE_ACTIVATE_CNF               0x000028AD

#define CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ   0x000028AE
#define CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_CNF   0x000028AF

#define CANOPEN_MASTER_SET_COMPARE_IMAGE_REQ            0x000028B0
#define CANOPEN_MASTER_SET_COMPARE_IMAGE_CNF            0x000028B1

#define CANOPEN_MASTER_SET_SYNC_TRIGGER_REQ              0x000028B2
#define CANOPEN_MASTER_SET_SYNC_TRIGGER_CNF              0x000028B3

#define CANOPEN_MASTER_SEND_SYNC_REQ                    0x000028B4
#define CANOPEN_MASTER_SEND_SYNC_CNF                    0x000028B5

#define CANOPEN_MASTER_SYNC_IND                         0x000028B6
#define CANOPEN_MASTER_SYNC_RES                         0x000028B7

#define CANOPEN_MASTER_RESET_ERROR_REQ                  0x000028B8
#define CANOPEN_MASTER_RESET_ERROR_CNF                  0x000028B9

/*Send and receive definitions*/
#define CANOPEN_MASTER_RECV_OBJECT_CNT    28

#define CANOPEN_MASTER_MIN_RECV_IDX       0x2200
#define CANOPEN_MASTER_MAX_RECV_IDX       0x221B

#define CANOPEN_MASTER_MIN_RECV_SUB_IDX   1
#define CANOPEN_MASTER_MAX_RECV_SUB_IDX   128

#define CANOPEN_MASTER_SEND_OBJECT_CNT    28

#define CANOPEN_MASTER_MIN_SEND_IDX       0x2000
#define CANOPEN_MASTER_MAX_SEND_IDX       0x201B

#define CANOPEN_MASTER_MIN_SEND_SUB_IDX   1
#define CANOPEN_MASTER_MAX_SEND_SUB_IDX   128

/*---------------------------------------------------------------------------------*/
/*
** Definitions for CANopen Master task, must be
** added to TLR_Header Files
*/
/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'CanOpen Master'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 CANOPEN_MASTER_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(CANOPEN_MASTER_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define CANOPEN_MASTER_QUEUE_NAME        "QUE_CANOPENMST"

/** @} */

/*************************************************************************************/
/* structures */


/** @name Structure Definition
 *
 * The following defined structures are used for packet commands
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_IO_STATUS_Ttag</code> */
typedef struct CANOPEN_MASTER_IO_STATUS_Ttag
  CANOPEN_MASTER_IO_STATUS_T;

__PACKED_PRE struct CANOPEN_MASTER_IO_STATUS_Ttag
{
  TLR_UINT32 ulHighestMappedSendBufferNum;
  TLR_UINT32 ulHighestMappedRecvBufferNum;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_STATE_Ttag</code> */
typedef struct CANOPEN_MASTER_STATE_Ttag
  CANOPEN_MASTER_STATE_T;

#define CANOPEN_MASTER_STATE_FLAG_RDY        0x00000001L
#define CANOPEN_MASTER_STATE_FLAG_RUN        0x00000002L
#define CANOPEN_MASTER_STATE_FLAG_COM        0x00000004L
#define CANOPEN_MASTER_STATE_FLAG_BUS_ON     0x00000008L
#define CANOPEN_MASTER_STATE_FLAG_COMM_ERROR 0x00000010L

__PACKED_PRE struct CANOPEN_MASTER_STATE_Ttag
{
  NETX_MASTER_STATUS          tNetxMasterState;    /* netX master state            */  
  TLR_UINT32                  ulCanState;          /* CAN state                    */ 
  CANOPEN_MASTER_IO_STATUS_T  tIoStatus;           /* IO Status                    */
  TLR_UINT32                  ulFlags;
  TLR_UINT32                  ulErrorCount; 
  TLR_UINT32                  ulCommError;
  TLR_UINT32                  ulRunLedState;
  TLR_UINT32                  ulErrLedState; 

  TLR_UINT32                  ulRecvDataCnt;
  TLR_UINT32                  ulSendDataCnt;
  
  TLR_UINT32                  ulReserved;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_CFG_BUS_PARAM_Ttag</code> */
typedef struct CANOPEN_MASTER_CFG_BUS_PARAM_Ttag
  CANOPEN_MASTER_CFG_BUS_PARAM_T;

#define CANOPEN_MASTER_MIN_MASTER_NODE_ID  1
#define CANOPEN_MASTER_MAX_MASTER_NODE_ID  127

#define CANOPEN_MASTER_CFG_BAUD_1000    0x00000000L   /* 1MBaud   */
#define CANOPEN_MASTER_CFG_BAUD_800     0x00000001L   /* 800kBaud */
#define CANOPEN_MASTER_CFG_BAUD_500     0x00000002L   /* 500kBaud */
#define CANOPEN_MASTER_CFG_BAUD_250     0x00000003L   /* 250kBaud */
#define CANOPEN_MASTER_CFG_BAUD_125     0x00000004L   /* 125kBaud */
#define CANOPEN_MASTER_CFG_BAUD_100     0x00000005L   /* 100kBaud */
#define CANOPEN_MASTER_CFG_BAUD_50      0x00000006L   /* 50kBaud  */
#define CANOPEN_MASTER_CFG_BAUD_20      0x00000007L   /* 20kBaud  */
#define CANOPEN_MASTER_CFG_BAUD_10      0x00000008L   /* 10kBaud  */

#define CANOPEN_MASTER_COB_ID_SYNC_MIN        0x00000001L
#define CANOPEN_MASTER_COB_ID_SYNC_MAX_11BIT  0x000007FFL
#define CANOPEN_MASTER_COB_ID_SYNC_MAX_29BIT  0x1FFFFFFFL

#define CANOPEN_MASTER_SYNC_TIMER_OFF         0x00000000L
#define CANOPEN_MASTER_MIN_SYNC_TIMER         0x00000001L
#define CANOPEN_MASTER_MAX_SYNC_TIMER         0x0000FFFFL

#define CANOPEN_MASTER_HEABT_TIME_OFF         0x00000000L
#define CANOPEN_MASTER_MIN_HEABT_TIME         0x00000001L
#define CANOPEN_MASTER_MAX_HEABT_TIME         0x0000FFFFL

#define CANOPEN_MASTER_AUTOCLEAR_DISABLE      0x00000000L
#define CANOPEN_MASTER_AUTOCLEAR_ENABLE       0x00000001L

#define CANOPEN_MASTER_FORMAT_NO_SWAP         0x00000000L
#define CANOPEN_MASTER_FORMAT_SWAP            0x00000001L

__PACKED_PRE struct CANOPEN_MASTER_CFG_BUS_PARAM_Ttag
{
  TLR_UINT32    ulMasterNodeId;       /* Node ID of CANopen Master         */
  TLR_UINT32    ulBaudRate;           /* Baudrate                          */
  TLR_BOOLEAN32 fGlobalStartNode;     /* Send global start node            */
  TLR_UINT32    ulUnused;             /* Unused                            */
  TLR_UINT32    ulAcceptCode;         /* Accept code for 29-Bit identifier */
  TLR_UINT32    ulAcceptMask;         /* Accept mask for 29-Bit identifier */
  TLR_UINT32    ulCobIdSync;          /* Master SYNC message               */
  TLR_UINT32    ulSyncTimer;          /* Cycletime of SYNC message         */
  TLR_UINT32    ulProdHeartbeatTimer; /* Producer heartbeat time           */
  TLR_UINT32    ulAutoClear;          /* Auto clear mode on/off            */
  TLR_UINT32    ulFormat;             /* Format                            */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_EMCY_ENTRYtag</code> */
typedef struct CANOPEN_MASTER_EMCY_ENTRY_Ttag
  CANOPEN_MASTER_EMCY_ENTRY_T;

#define CANOPEN_MASTER_EMCY_SIZE    0x08
#define CANOPEN_MASTER_MAX_EMCY_CNT 0x05

__PACKED_PRE struct CANOPEN_MASTER_EMCY_ENTRY_Ttag
{
  TLR_UINT8 abEmcyData[CANOPEN_MASTER_EMCY_SIZE];
}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_NODE_DIAGtag</code> */
typedef struct CANOPEN_MASTER_NODE_DIAG_Ttag
  CANOPEN_MASTER_NODE_DIAG_T;

#define CANOPEN_MASTER_ND_FLAG_SDO_TIMEOUT        0x00000001L
#define CANOPEN_MASTER_ND_FLAG_SDO_ERROR          0x00000002L
#define CANOPEN_MASTER_ND_FLAG_CFG_FAULT          0x00000004L
#define CANOPEN_MASTER_ND_FLAG_HEARTBEAT_STARTED  0x00000008L

#define CANOPEN_MASTER_ND_FLAG_GUARD_ERROR        0x00000010L
#define CANOPEN_MASTER_ND_FLAG_CON_LOST           0x00000020L
#define CANOPEN_MASTER_ND_FLAG_HEARTBEAT_ERROR    0x00000040L
#define CANOPEN_MASTER_ND_FLAG_UNEXPECTED_STATE   0x00000080L

#define CANOPEN_MASTER_ND_FLAG_EMCY_RECEIVED      0x00000100L
#define CANOPEN_MASTER_ND_FLAG_EMCY_BUFF_OVER     0x00000200L
#define CANOPEN_MASTER_ND_FLAG_BOOTUP             0x00000400L
#define CANOPEN_MASTER_ND_FLAG_UNEXPECTED_BOOTUP  0x00000800L

#define CANOPEN_MASTER_ND_FLAG_INVALID_PARAMETER  0x00001000L

#define CANOPEN_MASTER_ND_FLAG_STATE_NOT_HANDLED  0x40000000L
#define CANOPEN_MASTER_ND_FLAG_DEACTIVATED        0x80000000L

#define CANOPEN_MASTER_NODE_NMT_STATE_UNKNOWN           0x00000000L
#define CANOPEN_MASTER_NODE_NMT_STATE_INITIALISING      0x00000001L
#define CANOPEN_MASTER_NODE_NMT_STATE_STOPPED           0x00000002L
#define CANOPEN_MASTER_NODE_NMT_STATE_OPERATIONAL       0x00000003L
#define CANOPEN_MASTER_NODE_NMT_STATE_PRE_OPERATIONAL   0x00000004L
#define CANOPEN_MASTER_NODE_NMT_STATE_RESET_APPLICATION 0x00000005L
#define CANOPEN_MASTER_NODE_NMT_STATE_RESET_COMM        0x00000006L

__PACKED_PRE struct CANOPEN_MASTER_NODE_DIAG_Ttag
{
  TLR_UINT32    ulNodeFlags;             /* Flags of node (error and info)           */
  TLR_RESULT    eLastDiagInfo;           /* Last diagnostic information              */
  TLR_BOOLEAN32 fDeviceTypeValid;        /* Device Type in information is valid      */
  TLR_UINT32    ulDeviceType;            /* Device Type of node                      */
  TLR_UINT32    ulNmtState;              /* NMT state of node                        */
  TLR_UINT32    ulEmcyCnt;               /* Number of emergency telegrams in buffer  */
  CANOPEN_MASTER_EMCY_ENTRY_T atEmcyData[CANOPEN_MASTER_MAX_EMCY_CNT];
  TLR_UINT32    ulAddInfo;
  TLR_UINT32    aulReserved[4];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_GLOBAL_STATE_Ttag</code> */
typedef struct CANOPEN_MASTER_GLOBAL_STATE_Ttag
  CANOPEN_MASTER_GLOBAL_STATE_T;

#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_CTRL 0x01
#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_ACLR 0x02
#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_NEXC 0x04
#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_FAT  0x08

#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_EVE  0x10
#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_NRDY 0x20
#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_TOUT 0x40
#define CANOPEN_MASTER_GLOBAL_STATE_FLAG_MUL  0x80

#define CANOPEN_MASTER_GLOBAL_CAN_STATE_OFFLINE 0x00
#define CANOPEN_MASTER_GLOBAL_CAN_STATE_STOP    0x40
#define CANOPEN_MASTER_GLOBAL_CAN_STATE_CLEAR   0x80
#define CANOPEN_MASTER_GLOBAL_CAN_STATE_OPERATE 0xC0

#define CANOPEN_MASTER_GLOBAL_STATE_ERROR_SIZE 4
#define CANOPEN_MASTER_GLOBAL_NODE_LIST_SIZE   16

#define CANOPEN_MASTER_GLOBAL_DIAG      0x000000ffL

__PACKED_PRE struct CANOPEN_MASTER_GLOBAL_STATE_Ttag
{
  TLR_UINT8  bGlobalBits;
  TLR_UINT8  bCanState;
  TLR_UINT8  bErrorNodeAddress;
  TLR_UINT8  bErrorEvent;
  TLR_UINT16 usBusErrorCount;
  TLR_UINT16 usBusOffCount;
  TLR_UINT16 usMsgTimeOut;
  TLR_UINT16 usRxOverFlow;
  TLR_UINT8  abGlobalError[CANOPEN_MASTER_GLOBAL_STATE_ERROR_SIZE];
  TLR_UINT8  abListProjectedNodes[CANOPEN_MASTER_GLOBAL_NODE_LIST_SIZE];
  TLR_UINT8  abListActivatedNodes[CANOPEN_MASTER_GLOBAL_NODE_LIST_SIZE];
  TLR_UINT8  abListDiagnosticNodes[CANOPEN_MASTER_GLOBAL_NODE_LIST_SIZE];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_ADDITIONAL_INFO_Ttag</code> */
typedef struct CANOPEN_MASTER_ADDITIONAL_INFO_Ttag
  CANOPEN_MASTER_ADDITIONAL_INFO_T;

#define CANOPEN_MASTER_ADD_INFO_FLAG_CAN_INIT    0x00000001L
#define CANOPEN_MASTER_ADD_INFO_FLAG_CAN_ACTIVE  0x00000002L
#define CANOPEN_MASTER_ADD_INFO_FLAG_PASSIVE     0x00000004L
#define CANOPEN_MASTER_ADD_INFO_FLAG_BUS_OFF     0x00000008L

#define CANOPEN_MASTER_ADD_INFO_FLAG_RX_OVERFLOW 0x00000010L
#define CANOPEN_MASTER_ADD_INFO_FLAG_TX_OVERFLOW 0x00000020L

#define CANOPEN_MASTER_ADD_INFO_FLAG_WDG         0x00000100L

#define CANOPEN_MASTER_ADD_DETAIL_SIZE           0x00000003L

__PACKED_PRE struct CANOPEN_MASTER_ADDITIONAL_INFO_Ttag
{
  TLR_UINT32 ulFlags;
  TLR_UINT32 ulReserved;
  TLR_UINT32 ulLastDiagAddress;
  TLR_UINT32 ulLastDiagInfo;
  TLR_UINT32 ulBusOffEveCnt;
  TLR_UINT32 ulErrorPassiveEveCnt;
  TLR_UINT32 ulRxOverflowCnt;
  TLR_UINT32 ulTxOverflowCnt;
  TLR_UINT32 aulReserved[8]; 
  TLR_UINT32 ulMaxRecvIdx;
  TLR_UINT32 ulMaxSendIdx;
  TLR_UINT32 aulAddDetail[CANOPEN_MASTER_ADD_DETAIL_SIZE];  
   
}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_EXTENDED_STATE_Ttag</code> */
typedef struct CANOPEN_MASTER_EXTENDED_STATE_Ttag
  CANOPEN_MASTER_EXTENDED_STATE_T;
  
__PACKED_PRE struct CANOPEN_MASTER_EXTENDED_STATE_Ttag
{
  CANOPEN_MASTER_GLOBAL_STATE_T    tGlobalState;
  CANOPEN_MASTER_ADDITIONAL_INFO_T tAdditionalInfo;

}__PACKED_POST;

/*************************************************************************************/
/* packets */


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_APP_REGISTER_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_APP_REGISTER_REQ_DATA_Ttag
  CANOPEN_MASTER_APP_REGISTER_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_APP_REGISTER_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_APP_REGISTER_CNF_DATA_Ttag
  CANOPEN_MASTER_APP_REGISTER_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_APP_REGISTER_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_APP_REGISTER_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_EXCHANGE_DATA_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_EXCHANGE_DATA_REQ_DATA_Ttag
  CANOPEN_MASTER_EXCHANGE_DATA_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_EXCHANGE_DATA_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_EXCHANGE_DATA_CNF_DATA_Ttag
  CANOPEN_MASTER_EXCHANGE_DATA_CNF_DATA_T;

/** Structure of task command start/stop CANopen request data */
__PACKED_PRE struct CANOPEN_MASTER_EXCHANGE_DATA_REQ_DATA_Ttag
{
  TLR_UINT32 ulRecvIndex;     /* Object index for recv data     */
  TLR_UINT32 ulRecvSubIndex;  /* Object sub-index for recv data */
  TLR_UINT32 ulRecvDataCnt;   /* Recv data count                */

  TLR_UINT32 ulSendIndex;    /* Object index for send Data     */
  TLR_UINT32 ulSendSubIndex; /* Object sub-index for send Data */
  TLR_UINT32 ulSendDataCnt;  /* Send data count                */

  TLR_UINT8  abSendData[CANOPEN_MASTER_MAX_SEND_SUB_IDX];

}__PACKED_POST;

/** Structure of task command start/stop CANopen confirmation data */
__PACKED_PRE struct CANOPEN_MASTER_EXCHANGE_DATA_CNF_DATA_Ttag
{
  TLR_UINT32 ulRecvIndex;     /* Object index for recv data     */
  TLR_UINT32 ulRecvSubIndex;  /* Object sub-index for recv data */
  TLR_UINT32 ulRecvDataCnt;   /* Recv data count                */

  TLR_UINT32 ulSendIndex;    /* Object index for send Data     */
  TLR_UINT32 ulSendSubIndex; /* Object sub-index for send Data */
  TLR_UINT32 ulSendDataCnt;  /* Send data count                */

  TLR_UINT8  abRecvData[CANOPEN_MASTER_MAX_RECV_SUB_IDX];

}__PACKED_POST;

#define CANOPEN_MASTER_EXCHANGE_DATA_HEAD_SIZE 24

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_STARTSTOP_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_STARTSTOP_REQ_DATA_Ttag
  CANOPEN_MASTER_STARTSTOP_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_STARTSTOP_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_STARTSTOP_CNF_DATA_Ttag
  CANOPEN_MASTER_STARTSTOP_CNF_DATA_T;

#define CANOPEN_MASTER_STOP_CANOPEN     0x00000000L
#define CANOPEN_MASTER_START_CANOPEN    0x00000001L

/** Structure of task command start/stop CANopen request data */
__PACKED_PRE struct CANOPEN_MASTER_STARTSTOP_REQ_DATA_Ttag
{
  TLR_UINT32 ulMode;          /* Start or stop CAN        */

}__PACKED_POST;

/** Structure of task command start/stop CANopen confirmation data */
__PACKED_PRE struct CANOPEN_MASTER_STARTSTOP_CNF_DATA_Ttag
{
  TLR_UINT32 ulMode;          /* Start or stop CAN */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_INITIALIZE_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_INITIALIZE_REQ_DATA_Ttag
  CANOPEN_MASTER_INITIALIZE_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_INITIALIZE_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_INITIALIZE_CNF_DATA_Ttag
  CANOPEN_MASTER_INITIALIZE_CNF_DATA_T;

/** Structure of task command delete configuration CANopenrequest data */
__PACKED_PRE struct CANOPEN_MASTER_INITIALIZE_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved; /* Reserved fur further use */

}__PACKED_POST;

/** Structure of task command delete configuration confirmation data */
__PACKED_PRE struct CANOPEN_MASTER_INITIALIZE_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved; /* Reserved fur further use */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_SET_BUSPARAM_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SET_BUSPARAM_REQ_DATA_Ttag
  CANOPEN_MASTER_SET_BUSPARAM_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_SET_BUSPARAM_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SET_BUSPARAM_CNF_DATA_Ttag
  CANOPEN_MASTER_SET_BUSPARAM_CNF_DATA_T;

/** Structure of task command set bus param data */
__PACKED_PRE struct CANOPEN_MASTER_SET_BUSPARAM_REQ_DATA_Ttag
{
  CANOPEN_MASTER_CFG_BUS_PARAM_T tCfgBusParam;

}__PACKED_POST;

/** Structure of task command set bus param data */
__PACKED_PRE struct CANOPEN_MASTER_SET_BUSPARAM_CNF_DATA_Ttag
{
  CANOPEN_MASTER_CFG_BUS_PARAM_T tCfgBusParam;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_ND_PARAM_HEAD_Ttag</code> */
typedef struct CANOPEN_MASTER_ND_PARAM_HEAD_Ttag
  CANOPEN_MASTER_ND_PARAM_HEAD_T;
/** type of <code>CANOPEN_MASTER_SDO_CFG_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SDO_CFG_DATA_Ttag
  CANOPEN_MASTER_SDO_CFG_DATA_T;
/** type of <code>CANOPEN_MASTER_ND_SDO_CFG_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_ND_SDO_CFG_DATA_Ttag
  CANOPEN_MASTER_ND_SDO_CFG_DATA_T;
/** type of <code>CANOPEN_MASTER_PDO_CFG_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_PDO_CFG_DATA_Ttag
  CANOPEN_MASTER_PDO_CFG_DATA_T;
/** type of <code>CANOPEN_MASTER_ND_PDO_CFG_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_ND_PDO_CFG_DATA_Ttag
  CANOPEN_MASTER_ND_PDO_CFG_DATA_T;
/** type of <code>CANOPEN_MASTER_ND_PRM_ADD_TAB_Ttag</code> */
typedef struct CANOPEN_MASTER_ND_PRM_ADD_TAB_Ttag
  CANOPEN_MASTER_ND_PRM_ADD_TAB_T;

#define CANOPEN_MASTER_MIN_SLAVE_NODE_ID  1
#define CANOPEN_MASTER_MAX_SLAVE_NODE_ID  127

#define CANOPEN_MASTER_NODE_PARAM_ACTIVE  0x80
#define CANOPEN_MASTER_NODE_PARAM_HRTBT   0x40

#define CANOPEN_MASTER_COB_ID_NODE_MIN       0x0001
#define CANOPEN_MASTER_COB_ID_NODE_MAX_11BIT 0x07FF
#define CANOPEN_MASTER_COB_ID_NODE_MAX_29BIT 0xFFFF

#define CANOPEN_MASTER_NODE_CFG_NO_NODE_RESET 0x01
#define CANOPEN_MASTER_NODE_CFG_NO_CMP_DEVICE 0x02
#define CANOPEN_MASTER_NODE_CFG_NO_GUARD_CFG  0x04
#define CANOPEN_MASTER_NODE_CFG_NO_SYNC_ID    0x08
#define CANOPEN_MASTER_NODE_CFG_NO_EMCY_ID    0x10
#define CANOPEN_MASTER_NODE_CFG_NO_CFG_SDO    0x20
#define CANOPEN_MASTER_NODE_CFG_NO_START_NODE 0x40
#define CANOPEN_MASTER_NODE_CFG_NO_TX_RX_REQ  0x80

#define CANOPEN_MASTER_MAX_SDO_DATA_SIZE      0x04  /* Up to 4 bytes per SDO    */
#define CANOPEN_MASTER_MAX_SDOS               2000  /* Up to 2000 SDOs per node */

#define CANOPEN_MASTER_MAX_CFG_TPDOS           128  /* Up to 128 TPDOs per node */
#define CANOPEN_MASTER_MAX_CFG_RPDOS           128  /* Up to 128 RPDOs per node */

#define CANOPEN_MASTER_MAX_CFG_PDOS       \
          CANOPEN_MASTER_MAX_CFG_TPDOS  + \
          CANOPEN_MASTER_MAX_CFG_RPDOS 

#define CANOPEN_MASTER_PDO_TYPE_RX            0x00
#define CANOPEN_MASTER_PDO_TYPE_TX            0xFF

#define CANOPEN_MASTER_PDO_LENGTH_MSK         0x7F
#define CANOPEN_MASTER_PDO_WORD_MSK           0x80

#define CANOPEN_MASTER_PDO_MAX_LEN            0x08

#define CANOPEN_MASTER_MAX_NODEPARAM_DATA      512 /* Up to 512 byte per packet */

/** Structure of node parameter header */
__PACKED_PRE struct CANOPEN_MASTER_ND_PARAM_HEAD_Ttag
{
  TLR_UINT8  bNodeId;
  TLR_UINT16 Node_Para_Len;
  TLR_UINT8  bNd_Flag;
  TLR_UINT16 usAddInfo;
  TLR_UINT16 usDevProfNum;
  TLR_UINT16 usCobIDEmcy;
  TLR_UINT16 usCobIDGuard;
  TLR_UINT16 usGuardTime;
  TLR_UINT8  bLifeTime;
  TLR_UINT8  bCfgNdState;
  TLR_UINT8  Octet_String[1];

}__PACKED_POST;

/** Structure of single sdo config data */
__PACKED_PRE struct CANOPEN_MASTER_SDO_CFG_DATA_Ttag
{
  TLR_UINT16 usIndex;
  TLR_UINT8  bSubIndex;
  TLR_UINT16 usLength;

  TLR_UINT8 abSdoValue[CANOPEN_MASTER_MAX_SDO_DATA_SIZE];

}__PACKED_POST;

#define CANOPEN_MASTER_SDO_HEAD_SIZE 0x05

/** Structure of complete node sdo config data */
__PACKED_PRE struct CANOPEN_MASTER_ND_SDO_CFG_DATA_Ttag
{
  TLR_UINT16  Sdo_Cfg_Data_Len;
  CANOPEN_MASTER_SDO_CFG_DATA_T Sdo_Cfg_Data[CANOPEN_MASTER_MAX_SDOS];

}__PACKED_POST;

/** Structure of single pdo config data */
__PACKED_PRE struct CANOPEN_MASTER_PDO_CFG_DATA_Ttag
{
  TLR_UINT8  bTypOfPdo; /* 0x00 = RX-PDO 0xFF = TX-PDO */
  TLR_UINT8  bLength;
  TLR_UINT16 usPdoCOBId;
  TLR_UINT8  bTransType;
  TLR_UINT16 usInhibit;

}__PACKED_POST;

#define CANOPEN_MASTER_PDO_HEAD_SIZE 0x07

/** Structure of complete node pdo config data */
__PACKED_PRE struct CANOPEN_MASTER_ND_PDO_CFG_DATA_Ttag
{
  TLR_UINT16 Pdo_Cfg_Data_Len;
  CANOPEN_MASTER_PDO_CFG_DATA_T Pdo_Cfg_Data[CANOPEN_MASTER_MAX_CFG_PDOS];

}__PACKED_POST;

/** Structure of address table of node */
__PACKED_PRE struct CANOPEN_MASTER_ND_PRM_ADD_TAB_Ttag
{
  TLR_UINT16 Add_Tab_Len;
  TLR_UINT8  bTxPdoCount;
  TLR_UINT8  bRxPdoCount;
  TLR_UINT16 EA_Offset[CANOPEN_MASTER_MAX_CFG_PDOS];

}__PACKED_POST;

#define CANOPEN_MASTER_ADD_TAB_HEAD_SIZE 0x04

/** type of <code>CANOPEN_MASTER_SET_NODEPARAM_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SET_NODEPARAM_REQ_DATA_Ttag
  CANOPEN_MASTER_SET_NODEPARAM_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_SET_NODEPARAM_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SET_NODEPARAM_CNF_DATA_Ttag
  CANOPEN_MASTER_SET_NODEPARAM_CNF_DATA_T;

/** Structure of task command set node param data */
__PACKED_PRE struct CANOPEN_MASTER_SET_NODEPARAM_REQ_DATA_Ttag
{
  TLR_UINT8 abNodeParamData[CANOPEN_MASTER_MAX_NODEPARAM_DATA];

}__PACKED_POST;

/** Structure of task command set node param data */
__PACKED_PRE struct CANOPEN_MASTER_SET_NODEPARAM_CNF_DATA_Ttag
{
  TLR_UINT8  abNodeParamData[CANOPEN_MASTER_MAX_NODEPARAM_DATA];

}__PACKED_POST;

#define CANOPEN_MASTER_MAX_NODE_PARAM_CFG_SIZE     \
        sizeof(CANOPEN_MASTER_ND_PARAM_HEAD_T  ) + \
        sizeof(CANOPEN_MASTER_ND_SDO_CFG_DATA_T) + \
        sizeof(CANOPEN_MASTER_ND_PDO_CFG_DATA_T) + \
        sizeof(CANOPEN_MASTER_ND_PRM_ADD_TAB_T )   \

/*************************************************************************************/
#define CANOPEN_MASTER_NODE_DIAG_FLAG_PEEK  0x00000001L

/** type of <code>CANOPEN_MASTER_GET_NODE_DIAG_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_GET_NODE_DIAG_REQ_DATA_Ttag
  CANOPEN_MASTER_GET_NODE_DIAG_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_GET_NODE_DIAG_CNF_DATA_T</code> */
typedef struct CANOPEN_MASTER_GET_NODE_DIAG_CNF_DATA_Ttag
  CANOPEN_MASTER_GET_NODE_DIAG_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_GET_NODE_DIAG_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulFlags;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_GET_NODE_DIAG_CNF_DATA_Ttag
{
  TLR_UINT32                 ulNodeId;
  TLR_UINT32                 ulFlags;
  CANOPEN_MASTER_NODE_DIAG_T tNodeDiag;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_GET_BUFFER_HANDLE_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_GET_BUFFER_HANDLE_REQ_DATA_Ttag
  CANOPEN_MASTER_GET_BUFFER_HANDLE_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_GET_BUFFER_HANDLE_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_GET_BUFFER_HANDLE_CNF_DATA_Ttag
  CANOPEN_MASTER_GET_BUFFER_HANDLE_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_GET_BUFFER_HANDLE_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_GET_BUFFER_HANDLE_CNF_DATA_Ttag
{
  TLR_UINT32 aulRecvBuffer[CANOPEN_MASTER_RECV_OBJECT_CNT];
  TLR_UINT32 aulSendBuffer[CANOPEN_MASTER_SEND_OBJECT_CNT];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_STATE_CHANGE_IND_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_STATE_CHANGE_IND_DATA_Ttag
  CANOPEN_MASTER_STATE_CHANGE_IND_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_STATE_CHANGE_IND_DATA_Ttag
{
  CANOPEN_MASTER_STATE_T          tMasterState;    /* Master state                   */
  CANOPEN_MASTER_EXTENDED_STATE_T tExtMasterState; /* Extended Master state          */

}__PACKED_POST;

/*************************************************************************************/
#define CANOPEN_MASTER_MAX_SDO_DATA       512
#define CANOPEN_MASTER_SDO_DATA_HEAD_SIZE 16

#define CANOPEN_MASTER_MAX_SDO_INDEX      0xFFFF
#define CANOPEN_MASTER_MAX_SDO_SUB_INDEX  0xFF

/** type of <code>CANOPEN_MASTER_SDO_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SDO_REQ_DATA_Ttag
  CANOPEN_MASTER_SDO_REQ_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_SDO_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulSubIndex;
  TLR_UINT32 ulDataCnt;
  TLR_UINT8  abSdoData[CANOPEN_MASTER_MAX_SDO_DATA];

}__PACKED_POST;

/** type of <code>CANOPEN_MASTER_SDO_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SDO_CNF_DATA_Ttag
  CANOPEN_MASTER_SDO_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_SDO_CNF_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulIndex;
  TLR_UINT32 ulSubIndex;
  TLR_UINT32 ulDataCnt;
  TLR_UINT8  abSdoData[CANOPEN_MASTER_MAX_SDO_DATA];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_SEND_EMCY_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SEND_EMCY_REQ_DATA_Ttag
  CANOPEN_MASTER_SEND_EMCY_REQ_DATA_T;

#define CANOPEN_MASTER_EMCY_DATA_SIZE 5

#define CANOPEN_MASTER_ERROR_REGISTER_ERROR_RESET      0x00

#define CANOPEN_MASTER_ERROR_REGISTER_GENERIC_BIT      0x01
#define CANOPEN_MASTER_ERROR_REGISTER_CURRENT_BIT      0x02
#define CANOPEN_MASTER_ERROR_REGISTER_VOLTAGE_BIT      0x04
#define CANOPEN_MASTER_ERROR_REGISTER_TEMPERATURE_BIT  0x08
#define CANOPEN_MASTER_ERROR_REGISTER_COMM_ERROR_BIT   0x10
#define CANOPEN_MASTER_ERROR_REGISTER_DEV_PROFILE_BIT  0x20
#define CANOPEN_MASTER_ERROR_REGISTER_RESERVED_BIT     0x40
#define CANOPEN_MASTER_ERROR_REGISTER_MANU_SPEC_BIT    0x80

__PACKED_PRE struct CANOPEN_MASTER_SEND_EMCY_REQ_DATA_Ttag
{
  TLR_UINT16 usErrorCode;
  TLR_UINT8  abManErrorCode[CANOPEN_MASTER_EMCY_DATA_SIZE];
  TLR_UINT8  bErrorRegister;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_NODE_NMT_COMMAND_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_NODE_NMT_COMMAND_REQ_DATA_Ttag
  CANOPEN_MASTER_NODE_NMT_COMMAND_REQ_DATA_T;

#define CANOPEN_MASTER_NMT_COMMAND_NODE_ID_ALL_NODES        0 /* All nodes, including Master*/
#define CANOPEN_MASTER_NMT_COMMAND_MIN_SINGLE_NODE_ID       1
#define CANOPEN_MASTER_NMT_COMMAND_MAX_SINGLE_NODE_ID       127
#define CANOPEN_MASTER_NMT_COMMAND_NODE_ID_ALL_REMOTE_NODES 128

#define CANOPEN_MASTER_NMT_COMMAND_START                 1
#define CANOPEN_MASTER_NMT_COMMAND_STOP                  2
#define CANOPEN_MASTER_NMT_COMMAND_ENTER_PREOPERATIONAL  128
#define CANOPEN_MASTER_NMT_COMMAND_RESET_NODE            129 /* Not supported for Master*/
#define CANOPEN_MASTER_NMT_COMMAND_RESET_COMMUNICATION   130 /* Not supported for Master*/

__PACKED_PRE struct CANOPEN_MASTER_NODE_NMT_COMMAND_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulNmtState;
  
}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_GET_SLAVE_CONN_INFO_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_GET_SLAVE_CONN_INFO_REQ_DATA_Ttag
  CANOPEN_MASTER_GET_SLAVE_CONN_INFO_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_GET_SLAVE_CONN_INFO_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_GET_SLAVE_CONN_INFO_CNF_DATA_Ttag
  CANOPEN_MASTER_GET_SLAVE_CONN_INFO_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_GET_SLAVE_CONN_INFO_REQ_DATA_Ttag
{
  TLR_UINT32 ulHandle;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_GET_SLAVE_CONN_INFO_CNF_DATA_Ttag
{
  TLR_UINT32                  ulHandle;
  TLR_UINT32                  ulStructID;
  CANOPEN_MASTER_NODE_DIAG_T  tNodeDiag;
  
}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_SLAVE_ACTIVATE_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SLAVE_ACTIVATE_REQ_DATA_Ttag
CANOPEN_MASTER_SLAVE_ACTIVATE_REQ_DATA_T;

#define CANOPEN_MASTER_SLAVE_ACTIVATE   0x00000001L
#define CANOPEN_MASTER_SLAVE_DEACTIVATE 0x00000002L

__PACKED_PRE struct CANOPEN_MASTER_SLAVE_ACTIVATE_REQ_DATA_Ttag
{
  TLR_UINT32 ulNodeId;
  TLR_UINT32 ulMode;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_Ttag
  CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_T;
/** type of <code>CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_Ttag
  CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_T;

#define CANOPEN_MASTER_DISABLE_PDO_COUNTER 0x00000000L /* Disable PDO counter */
#define CANOPEN_MASTER_ENABLE_PDO_COUNTER  0x00000001L /* Enable PDO counter  */

#define CANOPEN_MASTER_PDO_COUNTER_ELEMENTS	    128
#define CANOPEN_MASTER_PDO_COUNTER_ELEMENT_SIZE sizeof(TLR_UINT8)

/* structures for all needed packets of PDO-Counter-Functionality */
__PACKED_PRE struct CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_Ttag
{
  TLR_UINT32 ulMode;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_Ttag
{
  TLR_UINT32 ulMode;
  TLR_HANDLE hPdoCounterBuffer;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_SET_COMPARE_IMAGE_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SET_COMPARE_IMAGE_REQ_DATA_Ttag
  CANOPEN_MASTER_SET_COMPARE_IMAGE_REQ_DATA_T;

#define CANOPEN_MASTER_SET_COMPARE_IMAGE_PDO_NUM_ALL_PDO  0x0000

/* structures for all needed packets of set compare image */
__PACKED_PRE struct CANOPEN_MASTER_SET_COMPARE_IMAGE_REQ_DATA_Ttag
{
  TLR_UINT16 usPdoNummer; /*PDO-Number (Currently all PDOs (0) is supported only!!) */
  TLR_UINT8  abPdoData[CANOPEN_MASTER_PDO_MAX_LEN];  /*Value to be set              */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_SET_SYNC_TRIGGER_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_SET_SYNC_TRIGGER_REQ_DATA_Ttag
  CANOPEN_MASTER_SET_SYNC_TRIGGER_REQ_DATA_T;

#define CANOPEN_MASTER_SYNC_TRIGGER_TIME_CONTROLLED            0x00
#define CANOPEN_MASTER_SYNC_TRIGGER_NOTIFIED_TIME_CONTROLLED   0x01
#define CANOPEN_MASTER_SYNC_TRIGGER_APPLICATION_TRIGGERED      0x02

__PACKED_PRE struct CANOPEN_MASTER_SET_SYNC_TRIGGER_REQ_DATA_Ttag
{
  TLR_UINT8 bSyncTrigger;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_RESET_ERROR_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_MASTER_RESET_ERROR_REQ_DATA_Ttag
  CANOPEN_MASTER_RESET_ERROR_REQ_DATA_T;

__PACKED_PRE struct CANOPEN_MASTER_RESET_ERROR_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved;    /* Reserved, set to zero */

}__PACKED_POST;

/*************************************************************************************/

/** @} */


/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services, which
 * are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_APP_REGISTER_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_APP_REGISTER_REQ_Ttag
  CANOPEN_MASTER_PACKET_APP_REGISTER_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_APP_REGISTER_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_APP_REGISTER_CNF_Ttag
  CANOPEN_MASTER_PACKET_APP_REGISTER_CNF_T;

/** Structure of task command application register request*/
__PACKED_PRE struct CANOPEN_MASTER_PACKET_APP_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead;  /** packet header.       */
  CANOPEN_MASTER_APP_REGISTER_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand application register confirmation */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_APP_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                    tHead;  /** packet header.       */
  CANOPEN_MASTER_APP_REGISTER_CNF_DATA_T tData;  /** packet request data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_EXCHANGE_DATA_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_EXCHANGE_DATA_REQ_Ttag
  CANOPEN_MASTER_PACKET_EXCHANGE_DATA_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_EXCHANGE_DATA_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_EXCHANGE_DATA_CNF_Ttag
  CANOPEN_MASTER_PACKET_EXCHANGE_DATA_CNF_T;

/** Structure of task command exchange data request*/
__PACKED_PRE struct CANOPEN_MASTER_PACKET_EXCHANGE_DATA_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;   /** packet header.       */
  CANOPEN_MASTER_EXCHANGE_DATA_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand exchange data confirmation */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_EXCHANGE_DATA_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;   /** packet header.            */
  CANOPEN_MASTER_EXCHANGE_DATA_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_STARTSTOP_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_STARTSTOP_REQ_Ttag
  CANOPEN_MASTER_PACKET_STARTSTOP_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_STARTSTOP_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_STARTSTOP_CNF_Ttag
  CANOPEN_MASTER_PACKET_STARTSTOP_CNF_T;

/** Structure of task command start/stop CANopen request */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_STARTSTOP_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;  /** packet header.       */
  CANOPEN_MASTER_STARTSTOP_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task command start/stop CANopen confirmation */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_STARTSTOP_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;  /** packet header.            */
  CANOPEN_MASTER_STARTSTOP_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_INITIALIZE_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_INITIALIZE_REQ_Ttag
  CANOPEN_MASTER_PACKET_INITIALIZE_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_INITIALIZE_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_INITIALIZE_CNF_Ttag
  CANOPEN_MASTER_PACKET_INITIALIZE_CNF_T;

/** Structure of task command delete configuration request */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_INITIALIZE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                  tHead;  /** packet header.       */
  CANOPEN_MASTER_INITIALIZE_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand delete configuration confirmation */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_INITIALIZE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                  tHead;  /** packet header.            */
  CANOPEN_MASTER_INITIALIZE_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SET_BUSPARAM_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_BUSPARAM_REQ_Ttag
  CANOPEN_MASTER_PACKET_SET_BUSPARAM_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_SET_BUSPARAM_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_BUSPARAM_CNF_Ttag
  CANOPEN_MASTER_PACKET_SET_BUSPARAM_CNF_T;

/** Structure of task command set bus parameter request */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_BUSPARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header.       */
  CANOPEN_MASTER_SET_BUSPARAM_REQ_DATA_T tData; /** packet request data. */

}__PACKED_POST;

/** Structure of task comand set bus parameter confirmation */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_BUSPARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header.            */
  CANOPEN_MASTER_SET_BUSPARAM_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SET_NODEPARAM_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_NODEPARAM_REQ_Ttag
  CANOPEN_MASTER_PACKET_SET_NODEPARAM_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_SET_NODEPARAM_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_NODEPARAM_CNF_Ttag
  CANOPEN_MASTER_PACKET_SET_NODEPARAM_CNF_T;

/** Structure of task command set node parameter request */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_NODEPARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead; /** packet header.       */
  CANOPEN_MASTER_SET_NODEPARAM_REQ_DATA_T tData; /** packet request data. */

}__PACKED_POST;

/** Structure of task comand set node parameter confirmation */
__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_NODEPARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead; /** packet header.            */
  CANOPEN_MASTER_SET_NODEPARAM_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_GET_NODE_DIAG_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_GET_NODE_DIAG_REQ_Ttag
  CANOPEN_MASTER_PACKET_GET_NODE_DIAG_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_GET_NODE_DIAG_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_GET_NODE_DIAG_CNF_Ttag
  CANOPEN_MASTER_PACKET_GET_NODE_DIAG_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_GET_NODE_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead; /** packet header.            */
  CANOPEN_MASTER_GET_NODE_DIAG_REQ_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_GET_NODE_DIAG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead; /** packet header.            */
  CANOPEN_MASTER_GET_NODE_DIAG_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_Ttag
  CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_Ttag
  CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead; /** packet header.            */
  CANOPEN_MASTER_GET_BUFFER_HANDLE_REQ_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                         tHead; /** packet header.            */
  CANOPEN_MASTER_GET_BUFFER_HANDLE_CNF_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_STATE_CHANGE_IND_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_STATE_CHANGE_IND_Ttag
  CANOPEN_MASTER_PACKET_STATE_CHANGE_IND_T;
/** type of <code>CANOPEN_MASTER_PACKET_STATE_CHANGE_RES_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_STATE_CHANGE_RES_Ttag
  CANOPEN_MASTER_PACKET_STATE_CHANGE_RES_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_STATE_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header.            */
  CANOPEN_MASTER_STATE_CHANGE_IND_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_STATE_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header.            */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SDO_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SDO_REQ_Ttag
  CANOPEN_MASTER_PACKET_SDO_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_SDO_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SDO_CNF_Ttag
  CANOPEN_MASTER_PACKET_SDO_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SDO_REQ_Ttag
{
  TLR_PACKET_HEADER_T           tHead; /** packet header.            */
  CANOPEN_MASTER_SDO_REQ_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SDO_CNF_Ttag
{
  TLR_PACKET_HEADER_T           tHead; /** packet header.            */
  CANOPEN_MASTER_SDO_CNF_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SEND_EMCY_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SEND_EMCY_REQ_Ttag
  CANOPEN_MASTER_PACKET_SEND_EMCY_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_SEND_EMCY_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SEND_EMCY_CNF_Ttag
  CANOPEN_MASTER_PACKET_SEND_EMCY_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SEND_EMCY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header.            */
  CANOPEN_MASTER_SEND_EMCY_REQ_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SEND_EMCY_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_REQ_Ttag
  CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_CNF_Ttag
  CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead; /** packet header.            */
  CANOPEN_MASTER_NODE_NMT_COMMAND_REQ_DATA_T tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_NODE_NMT_COMMAND_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag
  CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag
  CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_REQ_Ttag
  CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_REQ_T;
/** type of <code>CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_CNF_Ttag
  CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;                           /** packet header. */
  CANOPEN_MASTER_GET_SLAVE_CONN_INFO_REQ_DATA_T tData; /** packet data    */
  
}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_GET_SLAVE_CONN_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                           /** packet header. */
  CANOPEN_MASTER_GET_SLAVE_CONN_INFO_CNF_DATA_T tData; /** packet data    */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_REQ_Ttag
  CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_REQ_T;

/** type of <code>CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_CNF_Ttag
  CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;                      /** packet header. */
  CANOPEN_MASTER_SLAVE_ACTIVATE_REQ_DATA_T tData; /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SLAVE_ACTIVATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header. */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_REQ_Ttag
  CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_REQ_T;

/** type of <code>CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_CNF_Ttag
  CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                  tHead;  /** packet header. */
  CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_REQ_DATA_T tData;	 /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_ENABLE_DISABLE_PDO_COUNTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                  tHead;   /** packet header. */
  CANOPEN_MASTER_ENABLE_DISABLE_PDO_COUNTER_CNF_DATA_T tData;	  /** packet data    */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_REQ_Ttag
  CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_REQ_T;

/** type of <code>CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_CNF_Ttag
  CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                         tHead;  /** packet header. */
  CANOPEN_MASTER_SET_COMPARE_IMAGE_REQ_DATA_T tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_COMPARE_IMAGE_CNF_Ttag
{
  TLR_PACKET_HEADER_T  tHead;   /** packet header. */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_REQ_Ttag
  CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_REQ_T;

/** type of <code>CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_CNF_Ttag
CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header. */
  CANOPEN_MASTER_SET_SYNC_TRIGGER_REQ_DATA_T tData; /** packet data*/

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SET_SYNC_TRIGGER_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;   /** packet header. */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SEND_SYNC_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SEND_SYNC_REQ_Ttag
  CANOPEN_MASTER_PACKET_SEND_SYNC_REQ_T;

/** type of <code>CANOPEN_MASTER_PACKET_SEND_SYNC_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SEND_SYNC_CNF_Ttag
  CANOPEN_MASTER_PACKET_SEND_SYNC_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SEND_SYNC_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SEND_SYNC_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;   /** packet header. */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_SYNC_IND_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SYNC_IND_Ttag
  CANOPEN_MASTER_PACKET_SYNC_IND_T;

/** type of <code>CANOPEN_MASTER_PACKET_SYNC_RES_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_SYNC_RES_Ttag
  CANOPEN_MASTER_PACKET_SYNC_RES_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SYNC_IND_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_SYNC_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;   /** packet header. */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_MASTER_PACKET_RESET_ERROR_REQ_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_RESET_ERROR_REQ_Ttag
CANOPEN_MASTER_PACKET_RESET_ERROR_REQ_T;

/** type of <code>CANOPEN_MASTER_PACKET_RESET_ERROR_CNF_Ttag</code> */
typedef struct CANOPEN_MASTER_PACKET_RESET_ERROR_CNF_Ttag
CANOPEN_MASTER_PACKET_RESET_ERROR_CNF_T;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_RESET_ERROR_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header. */
  CANOPEN_MASTER_RESET_ERROR_REQ_DATA_T tData;  /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_MASTER_PACKET_RESET_ERROR_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;

/** @} */

/*************************************************************************************/

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__CANOPEN_MASTER_PUBLIC)
#endif

#endif /* #ifndef __CANOPEN_MASTER_PUBLIC_H */

/**************************************************************************************/
/*------------------------------------------------------------------------------------*/
/*-----------------------------EOF----------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**************************************************************************************/
